
#ifndef _OPVX_APU_H
#define _OPVX_APU_H


#define APU_DMA_BLOCK_SIZE          512         // command block size is fixed 256 bytes. valid size must <2^15
#define APU_DMA_BLOCK_NUM           8           // number of command block pre-alloced.
#define APU_CELL_BLOCK_SIZE         64
#define APU_CELL_BLOCKS_PER_SPAN    32
#define APU_CELL_BIT_MASK           0x1f

#define FIFO_CNTL_ADDR              0x2820      // fifo control port base address
#define FIFO_IN_ADDR                0x2800      // fifo in register address
#define FIFO_OUT_ADDR               0x2840      // fifo out register address.

#define FIFO_LEVEL_REG              0
#define FIFO_STATUS_REG             1
#define FIFO_EVENT_REG              2
#define FIFO_IENABLE_REG            3
#define FIFO_ALMOSTFULL_REG         4
#define FIFO_ALMOSTEMPTY_REG        5


typedef struct opvx_apu                 //data struct for openvox application processor.
{
    unsigned char*                      tx_dma_buf_host_addr;
    unsigned int                        tx_dma_buf_dma_addr;

    volatile unsigned char*             rx_dma_buf_host_addr;

    int                                 tx_dma_buf_index;
    int                                 rx_dma_buf_index;
    int                                 tx_dma_buf_offset;
    int                                 rx_dma_buf_offset;

    unsigned int                        use_apu_dma ;
    unsigned int                        apu_vpm_configed ;
    unsigned char                       expect_e1_irq_up_id ;
    unsigned char                       actual_e1_irq_dn_id ;
    unsigned char                       apu_check_alarms_flag ;
    unsigned char*                      cellbuf ;
    unsigned char                       cellbuf_write_index[4] ;    //per span
    unsigned char                       cellbuf_read_index[4] ;     //per span
    unsigned char                       cellbuf_depth[4] ;          //per span


    // ===  for debug and test only =====
    unsigned int                        ram_dma_cycles;
    unsigned int                        irq_active_cnt;
    unsigned int                        irq_active_cycles;
    unsigned int                        performance_host;


    unsigned int                        err_print_times;
    unsigned int                        tx_dma_buf_offset_max;
    unsigned int                        hdlc_tx_len_max ;
    unsigned char                       cellbuf_depth_max[4] ;      //per span
    unsigned int                        dmactl_update_cnt ;
    unsigned int                        host_flag_set_cnt ;
    unsigned int                        host_flag_clear_cnt ;
    unsigned int                        t4_pci_in_cnt ;
    unsigned int                        t4_pci_out_cnt ;
    unsigned int                        ec_sw_on_cnt ;
    unsigned int                        ec_sw_off_cnt ;
    unsigned int                        oct_set_reg_cnt ;
    unsigned int                        oct_get_reg_cnt ;
    struct timeval                      tpstart;
    struct timeval                      tpend;
    unsigned int                        tp_interval ;
    unsigned int                        irq_lose_cnt ;
} t_opvx_apu;


/* apu_command for quadfalc */
#define APU_CMD_QFALC_TX_HDLC				0x08			/* =FRMR_CMDR_XHF(0x08) */
#define APU_CMD_QFALC_TX_HDLC_COMPLETE	    0x0a			/* =FRMR_CMDR_XHF(0x08)|FRMR_CMDR_XME(0x02) */
#define APU_CMD_FRAMER_CMD_WAIT				0x82
#define APU_CMD_QFALC_SET_REG				0x83			/* set qfalc register  */
#define APU_CMD_QFALC_SET_BITS				0x84			/* set qfalc register specified bits  */
#define APU_CMD_QFALC_CLEAR_BITS			0x85			/* clear qfalc register specified bis  */
#define APU_CMD_QFALC_GET_REG				0x86			/* get qfalc register  */
#define APU_CMD_CHECK_ALARM  				0x87			/* get qfalc register  */
#define APU_CMD_ECHO_SWITCH  				0x88			/* get qfalc register  */




/* sub command when main cmd is APU_CMD_OTHER */
#define APU_CMD_SET_DMA_ADDR                0x1b010000          // set apu dma buffer start address.
                                                                // the following 1x32bit word is the dma address;
                                                                // this cmd also have a side effect that if dma address
                                                                // is zero, no apu operate will happen. i.e start/stop apu

#define APU_CMD_SET_SPAN_RBS                0x1b020000          // set span work model,
                                                                // the following 2x32bit word is :
                                                                // span number
                                                                // rbs style, :
                                                                //      APU_SPAN_RBS_TYPE_NO            0       /* do not handle RBS bits*/
                                                                //      APU_SPAN_RBS_TYPE_E1            1       /* handle RBS bits in E1 way */
                                                                //      APU_SPAN_RBS_TYPE_D4            2       /* handle RBS bits in D4 way */
                                                                //      APU_SPAN_RBS_TYPE_OTHER     3       /* handle RBS bits in other way*/

#define APU_CMD_SET_SPAN_HARDHDLC           0x1b030000          // set sig chan use hardhdlc or not
                                                                // following 2x32bit word is
                                                                // span number
                                                                // use hardhdlc=1, not use=0;

#define APU_CMD_HDLC_TX_DIRECT            0x1b040000
#define APU_CMD_EXTERNAL                    0x1b050000


/* apu events, unsigned char, up to 255 events supported */
#define APU_EVENT_FRAMER_IRQ            0x01         /* framer irq event, following registers:
                                                    framer id, 0= first framer, hold span 0..3
                                                    cis
                                                    gis0 of span 0
                                                    isr0 of span 0
                                                    ....
                                                    gis0 of span 3
                                                    isr0 of span 3 */

#define APU_EVENT_HDLC                  0x02        /* span hdlc event, data field: span, isr0, rsis_reg(valid if FRMR_ISR0_RME)
                                                       length of data in bytes, data */
#define APU_EVENT_RBS                   0x03        /* span rbs event, data field: span, t1e1, length of data in bytes, data*/
#define APU_EVENT_CHECK_ALARMS          0x04        /* span rbs event, data field: span, t1e1, length of data in bytes, data*/


#define APU_SPAN_RBS_TYPE_NO            0       /* do not handle RBS bits*/
#define APU_SPAN_RBS_TYPE_E1            1       /* handle RBS bits in E1 way */
#define APU_SPAN_RBS_TYPE_D4            2       /* handle RBS bits in D4 way */
#define APU_SPAN_RBS_TYPE_OTHER         3       /* handle RBS bits in other way*/





unsigned char*  apu_alloc_tx_buf(t_opvx_apu* apu);

#endif //_OPVX_APU_H
